<?php

namespace FiloBlu\Esb\Api;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Interface ObjectTypeDescriptorResolverInterface
 * @package FiloBlu\Esb\Api
 */
interface ObjectTypeDescriptorResolverInterface
{

    /**
     * @param $string
     * @return mixed
     */
    public function has($string);

    /**
     * @param $typCode
     * @throws NoSuchEntityException
     * @return ObjectTypeDescriptorInterface
     */
    public function get($typCode): ObjectTypeDescriptorInterface;

    /**
     * @return ObjectTypeDescriptorInterface[]
     */
    public function getAll(): array;
}
