<?php

namespace FiloBlu\Esb\Api;

use FiloBlu\Esb\Api\Data\ConsumerInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Interface ResolverInterface
 * @package FiloBlu\Esb\Api
 */
interface ConsumerResolverInterface
{
    /**
     * @return ConsumerInterface[]
     */
    public function getAll(): array;

    /**
     * @param string $identifier
     * @return ConsumerInterface
     * @throws NoSuchEntityException
     */
    public function get($identifier): ConsumerInterface;

    /**
     * @param string $identifier
     * @return bool
     */
    public function has($identifier): bool;
}
