<?php

namespace FiloBlu\Esb\Api;

use FiloBlu\Esb\Api\Data\ConsumerConfigurationInterface;
use FiloBlu\Esb\Api\Data\ConsumerInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Interface ConsumerConfigurationRepositoryInterface
 * @package FiloBlu\Esb\Api
 */
interface ConsumerConfigurationRepositoryInterface extends RepositoryInterface
{
    /**
     * @param ConsumerConfigurationInterface $configuration
     * @return mixed
     */
    public function save(ConsumerConfigurationInterface $configuration);

    /**
     * @param string|ConsumerInterface $consumer
     * @return ConsumerConfigurationInterface
     * @throws NoSuchEntityException
     */
    public function getByConsumer($consumer): ConsumerConfigurationInterface;

    /**
     * @param ConsumerConfigurationInterface $configuration
     * @return mixed
     */
    public function delete(ConsumerConfigurationInterface $configuration);
}
