define([
    'Magento_Ui/js/form/element/abstract',
    'Magento_Ui/js/lib/view/utils/async',
    'filoblu_esb_ace',
], function (Abstract, $) {
    'use strict';

    return Abstract.extend({
        editor: null,
        defaults: {
            template: 'ui/form/field',
            elementTmpl: 'FiloBlu_Esb/ui/form/element/ace',
            showSpinner: false,
            loading: false
        },
        /**
         * Initializes component, invokes initialize method of Abstract class.
         *
         *  @returns {Object} Chainable.
         */
        initialize: function () {
            this._super();
            let self = this;
            $.async('.filoblu_esb_ace_editor', this, function (node) {

                let baseUrl = require.s.contexts._.config.baseUrl;

                ace.config.set('basePath', `${baseUrl}FiloBlu_Esb/js`);
                ace.config.set('modePath', `${baseUrl}FiloBlu_Esb/js`);
                ace.config.set('themePath',`${baseUrl}FiloBlu_Esb/js`);
                ace.config.set('workerPath',`${baseUrl}FiloBlu_Esb/js`);
                ace.config.set('suffix', '.min.js');

                self.editor = ace.edit(node, {
                    mode: 'ace/mode/json',
                    minLines: 35,
                    maxLines: 5000
                });

                self.editor.getSession().setValue(JSON.stringify(JSON.parse(self.value()), null, 4));
                self.editor.on('change', function () {
                    self.value(self.editor.getSession().getValue());
                })

            }.bind(this));
            return this;
        }
    })
});