<?php

declare(strict_types=1);

namespace FiloBlu\Esb\Observer;

use Exception;
use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Framework\Event\EventEmitter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

/**
 * Observer on Product Save After
 */
class OrderSaveObserver implements ObserverInterface
{

    /**
     * @var EventEmitter
     */
    private $eventEmitter;
    /**
     * @var EventInterface
     */
    private $eventToEmit;

    /**
     * QuoteSaveAfter constructor.
     * @param EventEmitter $eventEmitter
     * @param EventInterface $eventToEmit
     */
    public function __construct(
        EventEmitter $eventEmitter,
        EventInterface $eventToEmit
    ) {
        $this->eventEmitter = $eventEmitter;
        $this->eventToEmit = $eventToEmit;
    }

    /**
     * @param Observer $observer
     * @return void
     * @throws Exception
     */
    public function execute(Observer $observer)
    {
        $order = $observer->getEvent()->getOrder();
        $this->eventEmitter->emit($this->eventToEmit, $order);
    }
}
