<?php

namespace FiloBlu\Esb\Observer;

use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Framework\Event\EventEmitter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

/**
 * Class CustomerRegisterSuccess
 * @package FiloBlu\Esb\Observer
 */
class CustomerRegisterSuccess implements ObserverInterface
{

    /**
     * @var EventEmitter
     */
    private $eventEmitter;
    /**
     * @var EventInterface
     */
    private $eventToEmit;

    /**
     * OrderSaveAfter constructor.
     * @param EventEmitter $eventEmitter
     * @param EventInterface $eventToEmit
     */
    public function __construct(EventEmitter $eventEmitter, EventInterface $eventToEmit)
    {
        $this->eventEmitter = $eventEmitter;
        $this->eventToEmit = $eventToEmit;
    }

    /**
     * @inheritDoc
     * @throws \Exception
     */
    public function execute(Observer $observer)
    {
        $customer = $observer->getData();
        $this->eventEmitter->emit($this->eventToEmit, $customer);
    }
}
