<?php

namespace FiloBlu\Esb\Model\Saver;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\ObjectTypeSaverInterface;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;
use Magento\Customer\Api\CustomerRepositoryInterface;
use RuntimeException;

/**
 * Class CustomerSaver
 * @package FiloBlu\Esb\Model\Saver
 */
class CustomerSaver extends AbstractEndpoint implements ObjectTypeSaverInterface
{
    /**
     * @var CustomerRepositoryInterface
     */
    private $customerRepository;

    /**
     * OrderLoader constructor.
     * @param CustomerRepositoryInterface $customerRepository
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     */
    public function __construct(CustomerRepositoryInterface $customerRepository, ObjectTypeDescriptorInterface $objectTypeDescriptor)
    {
        parent::__construct($objectTypeDescriptor);
        $this->customerRepository = $customerRepository;
    }

    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return 'Esb customer saver';
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::customer_saver';
    }

    /**
     * @inheritDoc
     */
    public function save(ObjectTypeDescriptorInterface $objectType, $objectToSave)
    {
        if (!$this->isSuitableFor($objectType)) {
            throw new RuntimeException("Incompatible loader for type {$objectType->getTypeCode()}");
        }

        $this->customerRepository->save($objectToSave);
    }
}
