<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\MessageInterface;
use Magento\Framework\DataObject;
use Magento\Framework\DataObjectFactory;

/**
 * Class Message
 * @package FiloBlu\Esb\Model
 */
class Message implements MessageInterface
{
    /**
     * @var DataObject
     */
    protected $data;
    /**
     * @var string
     */
    protected $event;
    /**
     * @var DataObjectFactory
     */
    protected $dataObjectFactory;

    /**
     * Message constructor.
     * @param DataObjectFactory $dataObjectFactory
     */
    public function __construct(DataObjectFactory $dataObjectFactory)
    {
        $this->dataObjectFactory = $dataObjectFactory;
    }

    /**
     * @inheritDoc
     */
    public function setPayload(DataObject $data)
    {
        $this->data = $data;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getPayload()
    {
        return $this->data ?: $this->dataObjectFactory->create(['data' => []]);
    }
}
