<?php

namespace FiloBlu\Esb\Model\Loader;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeInterface;
use FiloBlu\Esb\Api\ObjectTypeLoaderInterface;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;
use Magento\Sales\Api\CreditmemoRepositoryInterface;
use RuntimeException;

/**
 * Class CreditmemoLoader
 * @package FiloBlu\Esb\Model\Loader
 */
class CreditmemoLoader extends AbstractEndpoint implements ObjectTypeLoaderInterface
{
    /**
     * @var creditmemoRepositoryInterface
     */
    protected $creditmemoRepository;

    /**
     * CreditmemoLoader constructor.
     * @param creditmemoRepositoryInterface $creditmemoRepository
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     */
    public function __construct(creditmemoRepositoryInterface $creditmemoRepository, ObjectTypeDescriptorInterface $objectTypeDescriptor)
    {
        parent::__construct($objectTypeDescriptor);
        $this->creditmemoRepository = $creditmemoRepository;
    }

    /**
     * @inheritDoc
     */
    public function get(ObjectTypeInterface $objectType)
    {
        if (!$this->isSuitableFor($objectType)) {
            throw new RuntimeException("Incompatible loader for type {$objectType->getTypeCode()}");
        }

        return $this->creditmemoRepository->get($objectType->getId());
    }

    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return 'Esb creditmemo loader';
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::creditmemo_loader';
    }
}
