<?php

namespace FiloBlu\Esb\Model\Event;

use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;

/**
 * Class Event
 * @package FiloBlu\Esb\Model\Event
 */
class Event extends AbstractEndpoint implements EventInterface
{
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    protected $uniqueName;

    /**
     * Event constructor.
     * @param string $name
     * @param $uniqueName
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     */
    public function __construct(string $name, $uniqueName, ObjectTypeDescriptorInterface $objectTypeDescriptor)
    {
        parent::__construct($objectTypeDescriptor);
        $this->name = $name;
        $this->uniqueName = $uniqueName;
    }

    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return $this->uniqueName;
    }
}
