<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Interface OperatorInterface
 * @package FiloBlu\Esb\Core\Expression
 */
interface OperatorInterface
{
    /**
     * @return string
     */
    public function getSymbol();

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool;
}
