<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class NotEqualOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class NotEqualOperator implements OperatorInterface
{
    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'neq';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        return $leftOperand != $rightOperand;
    }
}
