<?php

declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class NotEndsWithOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class NotEndsWithOperator implements OperatorInterface
{

    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'nendswith';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        if($leftOperand === null || $rightOperand === null) {
            return false;
        }

        $length = strlen($rightOperand);

        if ($length == 0) {
            return true;
        }

        return (substr($leftOperand, -$length) != $rightOperand);
    }
}
