<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class LessThanEqualOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class LessThanEqualOperator implements OperatorInterface
{

    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'lte';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand)  : bool
    {
        return $leftOperand <= $rightOperand;
    }
}
