<?php

namespace FiloBlu\Esb\Converter;

use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class DataObjectConverterResolver
 * @package FiloBlu\Esb\Converter
 */
class DataObjectConverterResolver implements ConverterResolverInterface
{
    /**
     * @var ConverterInterface[]
     */
    protected $converters;

    /**
     * DataObjectConverterResolver constructor.
     * @param array $converters
     */
    public function __construct(array $converters)
    {
        $this->converters = $converters;
    }

    /**
     * @inheritDoc
     */
    public function getFor($object): ConverterInterface
    {
        foreach ($this->converters as $converter) {
            if (!$converter->canConvert($object)) {
                continue;
            }

            return $converter;
        }

        throw new NoSuchEntityException(__('No suitable convert for object "%1"', get_class($object)));
    }

    /**
     * @inheritDoc
     */
    public function get(string $converterIdentifier): ConverterInterface
    {
        foreach ($this->converters as $name => $converter) {
            if (!$name !== $converterIdentifier) {
                continue;
            }

            return $converter;
        }

        throw new NoSuchEntityException(__('No converter defined with identifier "%s"', $converterIdentifier));
    }

    /**
     * @inheritDoc
     */
    public function getAll(): array
    {
        return $this->converters;
    }
}
