<?php

namespace FiloBlu\Esb\Converter;

use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Interface ConverterResolverInterface
 * @package FiloBlu\Esb\Converter
 */
interface ConverterResolverInterface
{
    /**
     * Get converter or type
     * @param $object
     * @return ConverterInterface
     * @throws NoSuchEntityException
     */
    public function getFor($object): ConverterInterface;

    /**
     * @param string $converterIdentifier
     * @return ConverterInterface
     * @throws NoSuchEntityException
     */
    public function get(string $converterIdentifier): ConverterInterface;

    /**
     * @return ConverterInterface[]
     */
    public function getAll(): array;

}
