<?php

namespace FiloBlu\Esb\Controller\Adminhtml\Producer;

use Exception;
use FiloBlu\Esb\Api\ProducerConfigurationRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;

/**
 * Class Delete
 * @package FiloBlu\Esb\Controller\Adminhtml\Producer
 */
class Delete extends Action
{
    /**
     * @var ProducerConfigurationRepositoryInterface
     */
    private $producerConfigurationRepository;

    /**
     * Delete constructor.
     * @param Context $context
     * @param ProducerConfigurationRepositoryInterface $producerConfigurationRepository
     */
    public function __construct(
        Context $context,
        ProducerConfigurationRepositoryInterface $producerConfigurationRepository
    ) {
        parent::__construct($context);
        $this->producerConfigurationRepository = $producerConfigurationRepository;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id', null);
        if ($id === null) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        try {
            $this->producerConfigurationRepository->deleteById($id);
            $this->messageManager->addSuccessMessage(__('Deleted producer with id %1', $id));
        } catch (Exception $exception) {
            $this->messageManager->addExceptionMessage($exception);
        }

        return $this->resultRedirectFactory->create()->setPath('*/*/');
    }
}
