<?php

namespace FiloBlu\Esb\Controller\Adminhtml\Event;

use Exception;
use FiloBlu\Esb\Api\EventConfigurationRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class Delete
 * @package FiloBlu\Esb\Controller\Adminhtml\Event
 */
class Delete extends Action
{
    /**
     * @var EventConfigurationRepositoryInterface
     */
    private $eventConfigurationRepository;

    /**
     * Delete constructor.
     * @param Context $context
     * @param EventConfigurationRepositoryInterface $eventConfigurationRepository
     */
    public function __construct(Context $context, EventConfigurationRepositoryInterface $eventConfigurationRepository)
    {
        parent::__construct($context);
        $this->eventConfigurationRepository = $eventConfigurationRepository;
    }

    /**
     * @return ResponseInterface|ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id', null);
        if ($id === null) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        try {
            $this->eventConfigurationRepository->deleteById($id);
            $this->messageManager->addSuccessMessage(__('Deleted Event with id %1', $id));
        } catch (Exception $exception) {
            $this->messageManager->addExceptionMessage($exception);
        }

        return $this->resultRedirectFactory->create()->setPath('*/*/');
    }
}
