<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Block\Adminhtml\System\Config;

/**
 * Renderer for Event Configuration
 */

class Ack extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray
{
    
    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Status\Collection
     */
    protected $collection;

    /**
     * Statuses per state array
     *
     * @var array
     */
    protected $stateStatuses;

    /**
     * @var array
     */
    private $statuses;

    /**
     * @var Status
     */
    protected $orderStatusFactory;

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory
     */
    protected $orderStatusCollectionFactory;

    /**
     * Ack constructor.
     * @param \Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory $orderStatusCollectionFactory
     * @param \Magento\Backend\Block\Template\Context $context
     * @param array $data
     */
    public function __construct(        
        \Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory $orderStatusCollectionFactory,
        \Magento\Backend\Block\Template\Context $context, 
        array $data = []
    ) {
        $this->orderStatusCollectionFactory = $orderStatusCollectionFactory;
        parent::__construct($context, $data);
    }

    /**
     * Enable the "Add after" button or not
     *
     * @var bool
     */
    protected $_addAfter = false;

    /**
     * Rows cache
     *
     * @var array|null
     */
    private $_arrayRowsCache;

    /**
     * Prepare to render
     *
     * @return void
     */
    protected function _prepareToRender()
    {
               
        $this->addColumn('ack_flow', array(
            'label' => __('Ack Flow')

        ));
        $statuses = $this->orderStatusCollectionFactory->create()->toOptionHash();            

        $ackStatusBlock=$this->getLayout()->createBlock('Magento\Framework\View\Element\Html\Select')
                        ->setId($this->_getCellInputElementId('<%- _id %>','ack_set_status'))
                        ->setName($this->_getCellInputElementName('ack_set_status'))
                        ->setClass('select')
                        ->setOptions($statuses);

        $this->addColumn('ack_set_status', array(
            'label' => __('Set Status on Ack'),
            'renderer' => $ackStatusBlock
        ));

        $this->_addButtonLabel = __('Add Ack Flow');
    }
 
}
