<?php

namespace FiloBlu\Esb\Api;

use FiloBlu\Esb\Api\Data\QueueItemInterface;

/**
 * Interface QueueItemRepositoryInterface
 * @package FiloBlu\Esb\Api
 */
interface QueueItemRepositoryInterface extends RepositoryInterface
{

    /**
     * @var string
     */
    const DATE_FORMAT = 'Y-m-d H:i:s';

    /**
     * @param QueueItemInterface $item
     * @return QueueItemInterface
     */
    public function save(QueueItemInterface $item);

    /**
     * @param QueueItemInterface $item
     * @return mixed
     */
    public function delete(QueueItemInterface $item);

    /**
     * @param QueueItemInterface $item
     * @return bool
     */
    public function isPending(QueueItemInterface $item): bool;

}
