<?php

namespace FiloBlu\Esb\Api\Data;

/**
 * Interface ProducerInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface ProducerInterface extends ObjectTypeEndpointInterface
{
    /**
     * @param ProducerConfigurationInterface $configuration
     * @return mixed
     */
    public function configure(ProducerConfigurationInterface $configuration): ProducerInterface;

    /**
     * @return ProducerConfigurationInterface
     */
    public function getConfiguration(): ProducerConfigurationInterface;

    /**
     * @return MessageInterface
     */
    public function produce() : MessageInterface;

    /**
     * @return StatusInterface
     */
    public function getStatus() : StatusInterface;
}
