<?php

namespace FiloBlu\Esb\Ui\Component\Event\Form;

use FiloBlu\Esb\Api\Data\EventConfigurationInterface;
use FiloBlu\Esb\Api\EventConfigurationRepositoryInterface;
use FiloBlu\Esb\Ui\Component\AbstractDataProvider;
use Magento\Framework\Api\FilterBuilder;
use Magento\Framework\Api\Search\SearchCriteriaBuilder;
use Magento\Framework\App\RequestInterface;

/**
 * Class DataProvider
 * @package FiloBlu\Esb\Ui\Component\Event\Form
 */
class DataProvider extends AbstractDataProvider
{

    /**
     * @var EventConfigurationRepositoryInterface
     */
    protected $itemRepository;
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param EventConfigurationRepositoryInterface $itemRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param FilterBuilder $filterBuilder
     * @param RequestInterface $request
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        EventConfigurationRepositoryInterface $itemRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        FilterBuilder $filterBuilder,
        RequestInterface $request,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $searchCriteriaBuilder, $filterBuilder, $request, $meta, $data);
        $this->itemRepository = $itemRepository;
        $this->request = $request;
    }

    /**
     * @inheritDoc
     */
    public function getData()
    {
        $type = $this->request->getParam('type', null);

        if ($type !== null) {
            return [
                null => [
                    'event' => [
                        EventConfigurationInterface::BASE_EVENT => $type
                    ]

                ]
            ];
        }
        $result = $this->itemRepository->getList($this->getSearchCriteria(), true);

        $data = [];

        // @see \Magento\Ui\Component\Form
        foreach ($result->getItems() as $item) {
            $data[$item[$this->primaryFieldName]]['event'] = $item;
        }
        return $data;
    }

    /**
     * @inheritDoc
     */
    public function getSearchResult()
    {
        $searchCriteria = $this->getSearchCriteria();
        return $this->itemRepository->getList($searchCriteria);
    }
}
