<?php

namespace FiloBlu\Esb\Ui\Component\Consumer\Listing\Column;

use FiloBlu\Esb\Api\Data\ConsumerConfigurationInterface;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Actions
 * @package FiloBlu\Esb\Ui\Component\Consumer\Listing\Column
 */
class Actions extends Column
{
    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $item[$this->getData('name')] = [
                    'edit' => [
                        'href' => $this->context->getUrl(
                            'esb/consumer/edit',
                            (isset($item[ConsumerConfigurationInterface::ID]) ? ['id' => $item[ConsumerConfigurationInterface::ID]] : [])
                        ),
                        'label' => __('Edit')
                    ]
                ];
            }
        }

        return $dataSource;
    }
}
