<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Observer\Test\Unit;

use FiloBlu\Esb\Api\ConsumerResolverInterface;
use FiloBlu\Esb\Api\Data\ConsumerInterface;
use FiloBlu\Esb\Model\ConsumerResolver;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use PHPUnit\Framework\TestCase;

/**
 * Class ConsumerResolverTest
 * @package FiloBlu\Esb\Observer\Test\Unit
 */
class ConsumerResolverTest extends TestCase
{
    /**
     * @var ConsumerResolverInterface
     */
    protected $resolver;

    /**
     * @var string
     */
    protected $expectedMessage;

    /**
     *
     */
    public function setUp()
    {
        $objectManager = new ObjectManager($this);
        $dummyConsumer = $this->getMockBuilder(ConsumerInterface::class)->getMock();
        $this->resolver = $objectManager->getObject(ConsumerResolver::class, ['consumers' => ['dummy' => $dummyConsumer]]);
    }

    /**
     *
     */
    public function testHas()
    {
        $this->assertNotTrue($this->resolver->has('non_existent'));
        $this->assertTrue($this->resolver->has('dummy'));
        $this->assertInstanceOf(ConsumerInterface::class, $this->resolver->get('dummy'));
    }

}
