<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */

namespace FiloBlu\Esb\Observer;

use Exception;
use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Framework\Event\EventEmitter;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Customer\Model\Address\AddressModelInterface as AddressInterface;

/**
 * Observer on Customer Address Save After
 */
class CustomerAddressSaveAfter implements ObserverInterface
{

    /**
     * @var EventEmitter
     */
    private $eventEmitter;
    /**
     * @var EventInterface
     */
    private $eventToEmit;

    /**
     * OrderSaveAfter constructor.
     * @param EventEmitter $eventEmitter
     * @param EventInterface $eventToEmit
     */
    public function __construct(
        EventEmitter $eventEmitter,
        EventInterface $eventToEmit
    ) {
        $this->eventEmitter = $eventEmitter;
        $this->eventToEmit = $eventToEmit;
    }

    /**
     * @param Observer $observer
     * @return void
     * @throws Exception
     */
    public function execute(Observer $observer)
    {
        $customerAddress = $observer->getCustomerAddress();
        //$customer = $customerAddress->getCustomer();
        if ($customerAddress instanceof AddressInterface) {
            $this->eventEmitter->emit($this->eventToEmit, $customerAddress);
        } else {
            throw new \RuntimeException('Expected Object of type Customer');
        }
    }
}
