<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Model;

/**
 *
 */
class Response
{
    /**
     * @var string|null
     */
    private $rawRequest;

    /**
     * @var string|null
     */
    private $rawResponse;

    /**
     * @var array|null
     */
    private $errors;

    /**
     * @param $rawRequest
     * @param $rawResponse
     * @param $errors
     */
    public function __construct($rawRequest, $rawResponse, $errors)
    {
        $this->rawRequest = $rawRequest;
        $this->rawResponse = $rawResponse;
        $this->errors = $errors;
    }

    /**
     * @return array|null
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @return string|null
     */
    public function getRawRequest()
    {
        return $this->rawRequest;
    }

    /**
     * @return string|null
     */
    public function getRawResponse()
    {
        return $this->rawResponse;
    }

    /**
     * @return bool
     */
    public function isSuccessful(): bool
    {
        return $this->errors === null;
    }
}
