<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\MessageInterface;
use FiloBlu\Esb\Api\Data\QueueItemInterface;
use FiloBlu\Esb\Api\Data\StatusInterface;
use FiloBlu\Esb\Api\Data\StatusInterfaceFactory;

/**
 * Class QueueItem
 * @package FiloBlu\Esb\Model
 */
class QueueItem extends QueueMetadata implements QueueItemInterface
{
    /**
     * @var \FiloBlu\Esb\Api\Data\StatusInterfaceFactory
     */
    protected $statusFactory;
    /**
     * @var int
     */
    protected $id;
    /**
     * @var int
     */
    protected $priority = 0;
    /**
     * @var string
     */
    protected $event;
    /**
     * @var StatusInterface
     */
    protected $status;
    /**
     * @var MessageInterface
     */
    protected $message;

    /**
     * @var int
     */
    protected $retryCount = 0;
    /**
     * @var int
     */
    protected $retryItemId;
    /**
     * @var string|null
     */
    protected $messageHash;


    /**
     * QueueItem constructor.
     * @param StatusInterfaceFactory $statusFactory
     */
    public function __construct(StatusInterfaceFactory $statusFactory)
    {
        $this->statusFactory = $statusFactory;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return QueueItemInterface
     */
    public function setId($id): QueueItemInterface
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * @param int $priority
     * @return QueueItemInterface
     */
    public function setPriority($priority): QueueItemInterface
    {
        $this->priority = (int)$priority;
        return $this;
    }

    /**
     * @return string
     */
    public function getEvent()
    {
        return $this->event;
    }

    /**
     * @param string $event
     * @return QueueItemInterface
     */
    public function setEvent($event): QueueItemInterface
    {
        $this->event = $event;
        return $this;
    }

    /**
     * @return StatusInterface
     */
    public function getStatus()
    {
        if (!$this->status) {
            $this->status = $this->statusFactory->create();
        }
        return $this->status;
    }

    /**
     * @param StatusInterface $status
     * @return QueueItemInterface
     */
    public function setStatus(StatusInterface $status): QueueItemInterface
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return MessageInterface
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param MessageInterface $message
     * @return QueueItemInterface
     */
    public function setMessage(MessageInterface $message): QueueItemInterface
    {
        $this->message = $message;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getRetryCount(): int
    {
        return $this->retryCount;
    }

    /**
     * @inheritDoc
     */
    public function setRetryCount($count): QueueItemInterface
    {
        $this->retryCount = (int)$count;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getRetryItemId(): int
    {
        return (int)$this->retryItemId;
    }

    /**
     * @inheritDoc
     */
    public function setRetryItemId($id): QueueItemInterface
    {
        $this->retryItemId = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMessageHash()
    {
        return $this->messageHash;
    }

    /**
     * @param string| null $hash
     * @return \FiloBlu\Esb\Api\Data\QueueItemInterface
     */
    public function setMessageHash($hash): QueueItemInterface
    {
        $this->messageHash = $hash;
        return $this;
    }
}
