<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\ObjectTypeDescriptorResolverInterface;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class ObjectTypeDescriptorResolver
 * @package FiloBlu\Esb\Model
 */
class ObjectTypeDescriptorResolver implements ObjectTypeDescriptorResolverInterface
{
    /**
     * @var ObjectTypeDescriptorInterface[]
     */
    protected $objectTypes;

    /**
     * ObjectTypeDescriptorResolver constructor.
     * @param array $objectTypes
     */
    public function __construct(array $objectTypes)
    {
        $this->objectTypes = $objectTypes;
    }

    /**
     * @inheritDoc
     */
    public function has($string)
    {
        foreach ($this->objectTypes as $objectType) {
            if ($string === $objectType->getTypeCode()) {
                return true;
            }
        }

        return false;
    }

    /**
     * @inheritDoc
     */
    public function get($typCode): ObjectTypeDescriptorInterface
    {
        foreach ($this->objectTypes as $objectType) {
            if ($typCode === $objectType->getTypeCode()) {
                return $objectType;
            }
        }

        throw new NoSuchEntityException(__("No ObjectTypeDescriptor with code {$typCode}"));
    }

    /**
     * @inheritDoc
     */
    public function getAll(): array
    {
        return $this->objectTypes;
    }
}
