<?php

namespace FiloBlu\Esb\Core\Filler;

use FiloBlu\Esb\Api\Data\MessageInterface;
use Magento\Framework\DataObject;

/**
 * Class MessageFiller
 * @package FiloBlu\Esb\Core\Filler
 */
class MessageFiller
{
    /**
     * @param MessageInterface $message
     * @param DataObject $dataSource
     * @param array $template
     */
    public function fill(MessageInterface $message, DataObject $dataSource, array $template)
    {
        $payload = $message->getPayload();

        foreach ($template as $fromKey => $fromValue) {

            $value = $fromValue;
            if ($fromValue[0] === '{') {
                $path = trim($value, '{}');
                $value = $dataSource->getDataByPath($path);
            }

            $payload->setData($fromKey, $value);
        }

        $message->setPayload($payload);

    }
}
