<?php

declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class NotStartsWithOperator
 * @package FiloBlu\Esb\Core\Expression\Operator
 */
class NotStartsWithOperator implements OperatorInterface
{

    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'nstartswith';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        if($leftOperand === null || $rightOperand === null) {
            return false;
        }

        return (substr($leftOperand, 0, strlen($rightOperand)) != $rightOperand);
    }
}
