<?php
declare(strict_types=1);

namespace FiloBlu\Esb\Core\Expression\Operator;

/**
 * Class LessThanOperator
 */
class LessThanOperator implements OperatorInterface
{

    /**
     * @return string
     */
    public function getSymbol()
    {
        return 'lt';
    }

    /**
     * @param $leftOperand
     * @param $rightOperand
     * @return bool
     */
    public function execute($leftOperand, $rightOperand): bool
    {
        return $leftOperand < $rightOperand;
    }
}
