<?php

namespace FiloBlu\Esb\Core\Expression;

use Magento\Framework\DataObject;

/**
 * Interface EvaluatorInterface
 * @package FiloBlu\Esb\Core\Expression
 */
interface EvaluatorInterface
{

    /**
     * @param array $tokens
     * @return EvaluatorInterface
     */
    public function compile(array $tokens): EvaluatorInterface;

    /**
     * @param DataObject $data
     * @return int
     */
    public function evaluate(DataObject $data) : int;

    /**
     * @return EvaluatorInterface
     */
    public function reset() : EvaluatorInterface;
}
