<?php

namespace FiloBlu\Esb\Api\Data;

/**
 * Interface StatusInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface StatusInterface
{
    /** @var string */
    const ON_HOLD = 'on_hold';
    /** @var string */
    const PENDING = 'pending';
    /** @var string */
    const SUCCESS = 'success';
    /** @var string */
    const ERROR = 'error';
    /** @var string */
    const UNKNOWN = 'unknown';
    /** @var string */
    const SKIPPED = 'skipped';
    /** @var string */
    const PROCESSING = 'processing';
    /** @var string */
    const STATUS_INPUT = 'status_input_response';
    /** @var string */
    const STATUS_OUTPUT = 'status_output_response';

    /**
     * @return string
     */
    public function getCode(): string;

    /**
     * @param string $code
     * @return StatusInterface
     */
    public function setCode($code): StatusInterface;

    /**
     * @return string
     */
    public function getInputData();

    /**
     * @param string $data
     * @return StatusInterface
     */
    public function setInputData($data): StatusInterface;

    /**
     * @param string $data
     * @return StatusInterface
     */
    public function appendInputData($data): StatusInterface;

    /**
     * @return mixed
     */
    public function getOutputData();

    /**
     * @param string $data
     * @return StatusInterface
     */
    public function setOutputData($data): StatusInterface;

    /**
     * @param string $data
     * @return StatusInterface
     */
    public function appendOutputData($data) : StatusInterface;

}
