<?php

declare(strict_types=1);

namespace FiloBlu\Esb\Api\Data;

/**
 * Interface PublisherInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface PublisherInterface
{
    /**
     * @param MessageInterface $message
     * @param string $eventCode
     * @param QueueMetadataInterface $metadata
     * @return StatusInterface
     */
    public function publish(MessageInterface $message, string $eventCode, QueueMetadataInterface $metadata): StatusInterface;
}
