<?php

namespace FiloBlu\Esb\Api\Data;

/**
 * Interface ObjectTypeEndpointInterface
 * @package FiloBlu\Esb\Api\Data
 */
interface ObjectTypeEndpointInterface
{
    /**
     * Descriptive name
     * @return string
     */
    public function getName(): string;

    /**
     * Unique name {Vendor}_{Module}::name_in_lowercase_with_underscore
     * @return string
     */
    public function getUniqueName() : string;

    /**
     * @return ObjectTypeDescriptorInterface
     */
    public function getObjectTypeDescriptor(): ObjectTypeDescriptorInterface;

    /**
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     * @return bool
     */
    public function isSuitableFor(ObjectTypeDescriptorInterface $objectTypeDescriptor): bool;
}
