<?php

namespace FiloBlu\Esb\Setup;

use Exception;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\Order\StatusFactory;

/**
 * Class InstallData
 * @package FiloBlu\Esb\Setup
 */
class InstallData implements InstallDataInterface
{
    /**
     * @var StatusFactory
     */
    protected $statusFactory;

    /**
     * InstallData constructor.
     * @param StatusFactory $statusFactory
     */
    public function __construct(
        StatusFactory $statusFactory
    )
    {
        $this->statusFactory = $statusFactory;
    }

    /**
     * @param ModuleDataSetupInterface $setup
     * @param ModuleContextInterface $context
     * @throws Exception
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        $confirmedStatus = $this->statusFactory->create();
        $confirmedStatus->setData('status', 'confirmed');
        $confirmedStatus->setData('label', 'Confirmed');
        $confirmedStatus->save();
        $confirmedStatus->assignState(Order::STATE_PROCESSING, false, true);

        $orderExportedStatus = $this->statusFactory->create();
        $orderExportedStatus->setData('status', 'order_exported');
        $orderExportedStatus->setData('label', 'Order Exported');
        $orderExportedStatus->save();
        $orderExportedStatus->assignState(Order::STATE_PROCESSING, false, false);

        $paymentConfirmedStatus = $this->statusFactory->create();
        $paymentConfirmedStatus->setData('status', 'payment_confirmed');
        $paymentConfirmedStatus->setData('label', 'Payment Confirmed');
        $paymentConfirmedStatus->save();
        $paymentConfirmedStatus->assignState(Order::STATE_PROCESSING, false, true);

        $paymentExportedStatus = $this->statusFactory->create();
        $paymentExportedStatus->setData('status', 'payment_exported');
        $paymentExportedStatus->setData('label', 'Payment Exported');
        $paymentExportedStatus->save();
        $paymentExportedStatus->assignState(Order::STATE_PROCESSING, false, false);

        $invoicedStatus = $this->statusFactory->create();
        $invoicedStatus->setData('status', 'invoiced');
        $invoicedStatus->setData('label', 'Invoiced');
        $invoicedStatus->save();
        $invoicedStatus->assignState(Order::STATE_PROCESSING, false, true);

        $shippedStatus = $this->statusFactory->create();
        $shippedStatus->setData('status', 'shipped');
        $shippedStatus->setData('label', 'Shipped');
        $shippedStatus->save();
        $shippedStatus->assignState(Order::STATE_PROCESSING, false, true);

        $newStatus = $this->statusFactory->create();
        $newStatus->setData('status', 'sent_to_logistics');
        $newStatus->setData('label', 'Sent to Logistics');
        $newStatus->save();
        $newStatus->assignState(Order::STATE_PROCESSING, false, true);

        $setup->endSetup();
    }
}