<?php

namespace FiloBlu\Esb\Plugin\Magento\Sales\Api;

use Exception;
use FiloBlu\Esb\Api\Data\EventInterface;
use FiloBlu\Esb\Framework\Event\EventEmitter;

/**
 * Class CreditmemoRepositoryInterface
 *
 * @package FiloBlu\Esb\Plugin\Magento\Sales\Api
 */
class CreditmemoRepositoryInterface
{

    /**
     * @var EventEmitter
     */
    private $eventEmitter;
    /**
     * @var EventInterface
     */
    private $eventToEmit;

    /**
     * OrderSaveAfter constructor.
     * @param EventEmitter $eventEmitter
     * @param EventInterface $eventToEmit
     */
    public function __construct(EventEmitter $eventEmitter, EventInterface $eventToEmit)
    {
        $this->eventEmitter = $eventEmitter;
        $this->eventToEmit = $eventToEmit;
    }

    /**
     * @param \Magento\Sales\Api\CreditmemoRepositoryInterface $subject
     * @param $result
     * @return mixed
     * @throws Exception
     */
    public function afterSave(\Magento\Sales\Api\CreditmemoRepositoryInterface $subject, $result)
    {
        $this->eventEmitter->emit($this->eventToEmit, $result);
        return $result;
    }

}
