<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\StatusInterface;

/**
 * Class Status
 * @package FiloBlu\Esb\Model
 */
class Status implements StatusInterface
{
    /**
     * @var string
     */
    protected $code = StatusInterface::UNKNOWN;
    /**
     * @var
     */
    protected $inputData;
    /**
     * @var
     */
    protected $outputData;

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param $code
     * @return StatusInterface
     */
    public function setCode($code): StatusInterface
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getInputData()
    {
        return $this->inputData;
    }

    /**
     * @param mixed $data
     * @return StatusInterface
     */
    public function setInputData($data): StatusInterface
    {
        $this->inputData = $data;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getOutputData()
    {
        return $this->outputData;
    }

    /**
     * @param mixed $data
     * @return StatusInterface
     */
    public function setOutputData($data): StatusInterface
    {
        $this->outputData = $data;
        return $this;
    }

    /**
     * @param $data
     * @return $this|StatusInterface
     */
    public function appendOutputData($data): StatusInterface
    {
        if ($this->outputData) {
            $this->outputData .= $data;
            return $this;
        }

        $this->outputData = $data;
        return $this;
    }

    /**
     * @param string $data
     * @return $this|StatusInterface
     */
    public function appendInputData($data): StatusInterface
    {
        if ($this->inputData) {
            $this->inputData .= $data;
            return $this;
        }

        $this->inputData = $data;
        return $this;
    }
}
