<?php

namespace FiloBlu\Esb\Model\Saver;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\ObjectTypeSaverInterface;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;
use RuntimeException;

/**
 * Class NullSaver
 * @package FiloBlu\Esb\Model\Saver
 */
class NullSaver extends AbstractEndpoint implements ObjectTypeSaverInterface
{


    /**
     * @inheritDoc
     */
    public function getName(): string
    {
        return 'None';
    }

    /**
     * @inheritDoc
     */
    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::null_saver';
    }

    /**
     * @inheritDoc
     */
    public function save(ObjectTypeDescriptorInterface $objectType, $objectToSave)
    {
    }

    /**
     * @inheritDoc
     */
    public function isSuitableFor(ObjectTypeDescriptorInterface $objectTypeDescriptor): bool
    {
        return true;
    }
}
