<?php

namespace FiloBlu\Esb\Model\RetryStrategy;

use FiloBlu\Esb\Api\RetryStrategyResolverInterface;
use Magento\Framework\Api\SimpleDataObjectConverter;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Options
 * @package FiloBlu\Esb\Model\RetryStrategy
 */
class Options implements OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options = [];
    /**
     * @var RetryStrategyResolverInterface
     */
    private $strategyResolver;

    /**
     * Options constructor.
     * @param RetryStrategyResolverInterface $strategyResolver
     */
    public function __construct(RetryStrategyResolverInterface $strategyResolver)
    {
        $this->strategyResolver = $strategyResolver;
    }

    /**
     * @return array|null
     */
    public function toOptionArray()
    {
        if (empty($this->options)) {
            $result = $this->strategyResolver->getAll();

            foreach ($result as $name => $item) {
                $this->options[] = [
                    'value' => get_class($item),
                    'label' => SimpleDataObjectConverter::snakeCaseToUpperCamelCase($name)
                ];
            }
        }
        return $this->options;
    }
}
