<?php

namespace FiloBlu\Esb\Model;

use DateTime;
use FiloBlu\Esb\Api\Data\QueueItemInterface;
use FiloBlu\Esb\Api\Data\QueueMetadataInterface;

/**
 * Class QueueMetadata
 * @package FiloBlu\Esb\Model
 */
class QueueMetadata implements QueueMetadataInterface
{
    /**
     * @var DateTime
     */
    protected $executableAfter;
    /**
     * @var DateTime|null
     */
    protected $publishedAt;

    /**
     * @var DateTime|null
     */
    protected $executedAt;

    /**
     * @var DateTime
     */
    protected $finishedAt;

    /**
     * @var string
     */
    protected $processClass;

    /**
     * @var string
     */
    protected $processLabel;
    /**
     * @var string
     */
    protected $processUUID;
    /**
     * @var string
     */
    protected $from;
    /**
     * @var string
     */
    protected $to;

    /**
     * @return DateTime
     */
    public function getExecutableAfter()
    {
        return $this->executableAfter;
    }

    /**
     * @param DateTime $dateTime
     * @return $this
     */
    public function setExecutableAfter(DateTime $dateTime = null): QueueMetadataInterface
    {
        $this->executableAfter = $dateTime;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getPublishedAt()
    {
        return $this->publishedAt;
    }

    /**
     * @param DateTime|null $publishedAt
     * @return QueueItemInterface
     */
    public function setPublishedAt(DateTime $publishedAt = null): QueueMetadataInterface
    {
        $this->publishedAt = $publishedAt;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getExecutedAt()
    {
        return $this->executedAt;
    }

    /**
     * @param DateTime|null $executedAt
     * @return QueueItemInterface
     */
    public function setExecutedAt(DateTime $executedAt = null): QueueMetadataInterface
    {
        $this->executedAt = $executedAt;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getFinishedAt()
    {
        return $this->finishedAt;
    }

    /**
     * @param DateTime $finishedAt
     * @return $this
     */
    public function setFinishedAt(DateTime $finishedAt = null): QueueMetadataInterface
    {
        $this->finishedAt = $finishedAt;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getProcessClass()
    {
        return $this->processClass;
    }

    /**
     * @inheritDoc
     */
    public function setProcessClass($processClass): QueueMetadataInterface
    {
        $this->processClass = $processClass;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getProcessLabel()
    {
        return $this->processLabel;
    }

    /**
     * @inheritDoc
     */
    public function setProcessLabel($label): QueueMetadataInterface
    {
        $this->processLabel = $label;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getProcessUUID(): string
    {
        return $this->processUUID;
    }

    /**
     * @inheritDoc
     */
    public function setProcessUUID($uuid): QueueMetadataInterface
    {
        $this->processUUID = $uuid;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getFrom(): string
    {
        return $this->from;
    }

    /**
     * @inheritDoc
     */
    public function getTo(): string
    {
        return $this->to;
    }

    /**
     * @inheritDoc
     */
    public function setFrom($uuid): QueueMetadataInterface
    {
        $this->from = $uuid;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function setTo($uuid): QueueMetadataInterface
    {
        $this->to = $uuid;
        return $this;
    }
}
