<?php

namespace FiloBlu\Esb\Model\Publisher;

use FiloBlu\Esb\Api\PublisherResolverInterface;
use Magento\Framework\Api\SimpleDataObjectConverter;
use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Options
 * @package FiloBlu\Esb\Model\Publisher
 */
class Options implements OptionSourceInterface
{
    /**
     * @var array
     */
    protected $options = [];

    /**
     * @var PublisherResolverInterface
     */
    private $publisherResolver;

    /**
     * Options constructor.
     * @param PublisherResolverInterface $publisherResolver
     */
    public function __construct(
        PublisherResolverInterface $publisherResolver
    ) {
        $this->publisherResolver = $publisherResolver;
    }

    /**
     * @return array|null
     */
    public function toOptionArray()
    {
        if (empty($this->options)) {
            $result = $this->publisherResolver->getAll();

            foreach ($result as $name => $item) {
                $this->options[] = [
                    'value' => $item,
                    'label' => SimpleDataObjectConverter::snakeCaseToUpperCamelCase($name)
                ];
            }
        }
        return $this->options;
    }
}
