<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\ObjectTypeSaverInterface;

/**
 * Interface ObjectTypeSaverResolverInterface
 * @package FiloBlu\Esb\Model
 */
interface ObjectTypeSaverResolverInterface
{

    /**
     * @param null $uniqueName
     * @return ObjectTypeSaverInterface
     */
    public function get($uniqueName): ObjectTypeSaverInterface;

    /**
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     * @return mixed
     */
    public function getFor(ObjectTypeDescriptorInterface $objectTypeDescriptor);

    /**
     * @param $uniqueName
     * @return bool
     */
    public function has($uniqueName): bool;

    /**
     * @return ObjectTypeSaverInterface[]
     */
    public function getAll(): array;
}
