<?php

namespace FiloBlu\Esb\Model;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeInterface;
use FiloBlu\Esb\Api\ObjectTypeLoaderInterface;

/**
 * Interface ObjectTypeLoaderResolverInterface
 * @package FiloBlu\Esb\Model
 */
interface ObjectTypeLoaderResolverInterface
{

    /**
     * @param string $uniqueName
     * @return ObjectTypeLoaderInterface
     */
    public function get($uniqueName): ObjectTypeLoaderInterface;

    /**
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     * @return ObjectTypeLoaderInterface
     */
    public function getFor(ObjectTypeDescriptorInterface $objectTypeDescriptor): ObjectTypeLoaderInterface;

    /**
     * @param $name
     * @return bool
     */
    public function has($name): bool;


    /**
     * @return ObjectTypeLoaderInterface[]
     */
    public function getAll(): array;
}
