<?php

namespace FiloBlu\Esb\Model\Consumer;

use FiloBlu\Esb\Api\Data\ConsumerConfigurationInterface;
use FiloBlu\Esb\Api\Data\ConsumerInterface;
use FiloBlu\Esb\Api\Data\MessageInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\Data\StatusInterface;
use FiloBlu\Esb\Api\Data\StatusInterfaceFactory;
use FiloBlu\Esb\Framework\ObjectType\Endpoint\AbstractEndpoint;

/**
 * Class VoidConsumer
 * @package FiloBlu\Esb\Model\Consumer
 */
class VoidConsumer extends AbstractEndpoint implements ConsumerInterface
{
    /** @var StatusInterface */
    protected $status;
    /** @var StatusInterfaceFactory  */
    protected $statusFactory;
    /**
     * @var ConsumerConfigurationInterface
     */
    protected $configuration;

    /**
     * VoidConsumer constructor.
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     * @param StatusInterfaceFactory $statusFactory
     */
    public function __construct(ObjectTypeDescriptorInterface $objectTypeDescriptor,
                                StatusInterfaceFactory $statusFactory)
    {
        parent::__construct($objectTypeDescriptor);
        $this->statusFactory = $statusFactory;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return 'Void';
    }

    /**
     * @param ConsumerConfigurationInterface $configuration
     * @return $this|ConsumerInterface
     */
    public function configure(ConsumerConfigurationInterface $configuration): ConsumerInterface
    {
        $this->configuration = $configuration;
        return $this;
    }

    public function getConfiguration(): ConsumerConfigurationInterface
    {
        return $this->configuration;
    }

    public function consume(MessageInterface $message): MessageInterface
    {
        return $message;
    }

    public function getStatus(): StatusInterface
    {
        return $this->status ?: ($this->status = $this->statusFactory->create());
    }

    public function getUniqueName(): string
    {
        return 'FiloBlu_Esb::void';
    }

    /**
     * @inheritDoc
     */
    public function isSuitableFor(ObjectTypeDescriptorInterface $objectTypeDescriptor): bool
    {
        return true;
    }
}
