<?php
/**
 * Copyright © 2016 Filoblu S.r.l. All rights reserved.
 */
namespace FiloBlu\Esb\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Backend Model used to populate Format select box
 */

class Format implements OptionSourceInterface
{
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [['value' => 'json', 'label' => __('JSON')], ['value' => 'xml', 'label' => __('XML')]];
    }

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray()
    {
        return ['json' => __('JSON'), 'xml' => __('XML')];
    }
}
