<?php

namespace FiloBlu\Esb\Framework\ObjectType\Endpoint;

use FiloBlu\Esb\Api\Data\ObjectTypeDescriptorInterface;
use FiloBlu\Esb\Api\Data\ObjectTypeEndpointInterface;

/**
 * Class AbstractEndpoint
 * @package FiloBlu\Esb\Framework\ObjectType\Endpoint
 */
abstract class AbstractEndpoint implements ObjectTypeEndpointInterface
{
    /**
     * @var ObjectTypeDescriptorInterface
     */
    private $objectTypeDescriptor;

    /**
     * @return string
     */
    abstract public function getName(): string;

    /**
     * AbstractEndpoint constructor.
     * @param ObjectTypeDescriptorInterface $objectTypeDescriptor
     */
    public function __construct(ObjectTypeDescriptorInterface $objectTypeDescriptor)
    {
        $this->objectTypeDescriptor = $objectTypeDescriptor;
    }

    /**
     * @inheritDoc
     */
    public function getObjectTypeDescriptor(): ObjectTypeDescriptorInterface
    {
        return $this->objectTypeDescriptor;
    }

    /**
     * @inheritDoc
     */
    public function isSuitableFor(ObjectTypeDescriptorInterface $objectTypeDescriptor): bool
    {
        return $this->objectTypeDescriptor ? $this->objectTypeDescriptor->getTypeCode() === $objectTypeDescriptor->getTypeCode() : false;
    }
}
