<?php

namespace FiloBlu\Esb\Controller\Adminhtml\Event;

use Exception;
use FiloBlu\Esb\Api\Data\EventConfigurationInterface;
use FiloBlu\Esb\Api\Data\EventConfigurationInterfaceFactory;
use FiloBlu\Esb\Api\EventConfigurationRepositoryInterface;
use FiloBlu\Esb\Api\EventResolverInterface;
use FiloBlu\Esb\Controller\Adminhtml\Common\AbstractEdit;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Edit
 * @package FiloBlu\Esb\Controller\Adminhtml\Event
 */
class Edit extends AbstractEdit
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;
    /**
     * @var EventConfigurationRepositoryInterface
     */
    private $eventRepository;
    /**
     * @var EventConfigurationInterfaceFactory
     */
    private $eventConfigurationFactory;
    /**
     * @var EventResolverInterface
     */
    private $eventResolver;

    /**
     * Constructor
     *
     * @param Context $context
     * @param EventConfigurationRepositoryInterface $eventRepository
     * @param EventConfigurationInterfaceFactory $eventConfigurationFactory
     * @param EventResolverInterface $eventResolver
     * @param PageFactory $resultPageFactory
     */
    public function __construct(
        Context $context,
        EventConfigurationRepositoryInterface $eventRepository,
        EventConfigurationInterfaceFactory $eventConfigurationFactory,
        EventResolverInterface $eventResolver,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->eventRepository = $eventRepository;
        $this->eventConfigurationFactory = $eventConfigurationFactory;
        $this->eventResolver = $eventResolver;
    }

    /**
     * Execute view action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $event = $this->getRequest()->getParam('event');

        if ($event !== null) {
            $id = $event[EventConfigurationInterface::ID] ?? null;
            try {
                /** @var EventConfigurationInterface $eventConfiguration */
                $eventConfiguration = $this->eventConfigurationFactory->create();

                $eventConfiguration
                    ->setLabel($event[EventConfigurationInterface::LABEL])
                    ->setBaseEvent($this->eventResolver->get($event[EventConfigurationInterface::BASE_EVENT]))
                    ->setEventCode($event[EventConfigurationInterface::EVENT_CODE])
                    ->setId($id)
                    ->setUuid($event[EventConfigurationInterface::UUID]);

                $this->eventRepository->save($eventConfiguration);
                $id = $eventConfiguration->getId();
                $this->messageManager->addSuccessMessage('Save success');
            } catch (Exception $exception) {
                $this->messageManager->addExceptionMessage($exception);
            }

            return $this->getRedirectPath($id);
        }

        return $this->resultPageFactory->create();
    }
}
