<?php

namespace FiloBlu\Esb\Controller\Adminhtml\Consumer;

use Exception;
use FiloBlu\Esb\Api\ConsumerConfigurationRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;

/**
 * Class Delete
 * @package FiloBlu\Esb\Controller\Adminhtml\Consumer
 */
class Delete extends Action
{
    /**
     * @var ConsumerConfigurationRepositoryInterface
     */
    private $consumerConfigurationRepository;

    /**
     * Delete constructor.
     * @param Context $context
     * @param ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository
     */
    public function __construct(
        Context $context,
        ConsumerConfigurationRepositoryInterface $consumerConfigurationRepository
    ) {
        parent::__construct($context);
        $this->consumerConfigurationRepository = $consumerConfigurationRepository;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('id', null);
        if ($id === null) {
            return $this->resultRedirectFactory->create()->setPath('*/*/');
        }

        try {
            $this->consumerConfigurationRepository->deleteById($id);
            $this->messageManager->addSuccessMessage(__('Deleted Consumer with id %1', $id));
        } catch (Exception $exception) {
            $this->messageManager->addExceptionMessage($exception);
        }

        return $this->resultRedirectFactory->create()->setPath('*/*/');
    }
}
