<?php

namespace FiloBlu\Esb\Block\Adminhtml\Queue\View;

use FiloBlu\Esb\Block\Adminhtml\Common\Button;

/**
 * Class EnqueueButton
 * @package FiloBlu\Esb\Block\Adminhtml\Queue\View
 */
class EnqueueButton extends Button
{

    /**
     * @return array
     */
    public function getButtonData()
    {
        if ($this->getId() === null) {
            return [];
        }

        return [
            'label' => __('Re-Enqueue'),
            'class' => 'action-secondary',
            'on_click' => 'confirmSetLocation(\''
                . __('Are you sure you want to re-enqueue this item ?')
                . '\', \'' . $this->getUrl('*/*/enqueue', ['id' => $this->getId()]) . '\')',
            'sort_order' => 20,
        ];
    }

    /**
     * @return string
     */
    protected function getId()
    {
        return $this->context->getRequest()->getParam('id', null);
    }

}
